from builtins import object

from django import forms
from django.contrib.auth import get_user_model

from kelvin.accounts.models import TeacherProfile

User = get_user_model()


class UserForm(forms.ModelForm):
    """Форма для админки пользователя"""
    class Meta(object):
        model = User
        fields = '__all__'

    def __init__(self, *args, **kwargs):
        super(UserForm, self).__init__(*args, **kwargs)
        f = self.fields.get('user_permissions')
        if f is not None:
            f.queryset = f.queryset.select_related('content_type')


class TeacherProfileForm(forms.ModelForm):
    """
    Форма для списка профилей учителя, которая добавляет поле подтверждения
    профиля
    """
    approved = forms.BooleanField(required=False)

    class Meta(object):
        model = TeacherProfile
        fields = '__all__'

    def __init__(self, *args, **kwargs):
        """
        Добавляем начальное значение поля `approved`
        """
        instance = kwargs.get('instance')
        if instance:
            initial = kwargs.get('initial', {})
            initial['approved'] = instance.teacher.is_teacher
            kwargs['initial'] = initial
        super(TeacherProfileForm, self).__init__(*args, **kwargs)

    def save(self, *args, **kwargs):
        """
        Сохраняем значение подтвержденности профиля
        """
        approved = self.cleaned_data.get('approved')
        profile = super(TeacherProfileForm, self).save(
            *args, **kwargs
        )
        profile.teacher.is_teacher = approved
        profile.teacher.save()
        return profile
