from django.contrib import admin
from django.utils.translation import ugettext_lazy as _

from kelvin.accounts.admin.forms import TeacherProfileForm
from kelvin.common.utils import EmptyTrueTuple


class TeacherProfileAdmin(admin.ModelAdmin):
    """
    Профили учителей
    """
    form = TeacherProfileForm
    list_display = (
        'get_teacher_name',
        'get_date_joined',
        'subject',
        'school',
        'region',
        'approved',
    )
    list_filter = ('subject',)
    list_select_related = ('teacher', 'subject')
    search_fields = (
        'teacher__username',
        'teacher__first_name',
        'teacher__middle_name',
        'teacher__last_name',
    )
    raw_id_fields = ('teacher', )

    # чтобы вызвать `get_changelist_form` свойство `list_editable` должно
    # быть логическим `True`
    list_editable = EmptyTrueTuple()

    def get_teacher_name(self, teacher_profile):
        """ФИО учителя"""
        return teacher_profile.teacher.get_full_name()
    get_teacher_name.short_description = _('ФИО')
    get_teacher_name.admin_order_field = 'teacher__last_name'

    def get_date_joined(self, teacher_profile):
        """Дата регистрации учителя"""
        return teacher_profile.teacher.date_joined
    get_date_joined.short_description = _('Дата регистрации')
    get_date_joined.admin_order_field = 'teacher__date_joined'

    # def get_changelist_form(self, request, **kwargs):
    #     """
    #     Форма для изменения модели в списке, добавляем поле подтвержденности
    #     профиля
    #     """
    #     return TeacherProfileChangeListForm
