from django.contrib.auth import get_user_model
from django.contrib.auth.models import AnonymousUser

from rest_framework.authentication import BaseAuthentication

User = get_user_model()


# DEPRECATED
class YandexAuthentication(BaseAuthentication):
    """
    DRF подменяет запрос и при обращении к `request.user` проводит собственную
    аутентификацию, которая в нашем случае проводится в `YandexAuthMiddleware`
    """
    def authenticate(self, request):
        # if request._request.yauser.is_authenticated():
        if request.user.is_authenticated:
            return request._request.user, None

    def authenticate_header(self, request):
        """Чтобы возвращать 401 ошибку при неудачной аутентификации"""
        return 'Any'


class YandexCredentialsMixin:
    user_field = 'yauid'

    def get_user(self, userid):
        try:
            return User.objects.get(**{self.user_field: userid})
        except User.DoesNotExist:
            return AnonymousUser()

    def authenticate_credentials(self, userid):
        user = self.get_user(userid)
        return (user, None)


class DebugUIDAuthentication(YandexCredentialsMixin, BaseAuthentication):
    header = 'HTTP_DEBUG_UID'

    def authenticate(self, request):
        userid = request.META.get(self.header, None)
        if not userid:
            return None

        return self.authenticate_credentials(userid)


class TVMUserTicketAuthentication(YandexCredentialsMixin, BaseAuthentication):
    tvm_param = 'tvm_uid'

    def authenticate(self, request):
        userid = getattr(request._request, self.tvm_param, None)
        if not userid:
            return None

        return self.authenticate_credentials(userid)
