import random
from functools import partial

import factory

from django.utils.crypto import get_random_string

from kelvin.accounts.models import User


class UserFactory(factory.DjangoModelFactory):
    last_name = factory.Faker("last_name", locale="ru")
    first_name = factory.Faker("first_name", locale="ru")
    username = factory.LazyFunction(get_random_string)
    yauid = factory.LazyFunction(partial(random.randint, a=10 ** 10, b=10 ** 11 - 1))

    class Meta:
        model = User
