from django.core.management.base import BaseCommand

from kelvin.accounts.models import User


class Command(BaseCommand):
    help = 'Makes known user a superuser'

    def add_arguments(self, parser):
        parser.add_argument('username', type=str)

    def handle(self, *args, **options):

        user = User.objects.get(username=options['username'])
        user.is_superuser = True
        user.is_staff = True
        user.save()
