from django.db import migrations, models
from django.conf import settings
import kelvin.accounts.models.user


class Migration(migrations.Migration):

    replaces = [('accounts', '0001_initial'), ('accounts', '0002_remove_user_achievements')]

    dependencies = [
        ('auth', '0006_require_contenttypes_0002'),
        ('subjects', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(blank=True, unique=True, max_length=255, verbose_name='username', error_messages={'unique': 'A user with that username already exists.'})),
                ('email', models.EmailField(null=True, error_messages={'unique': 'A user with that email already exists.'}, max_length=255, blank=True, unique=True, verbose_name='E-mail')),
                ('first_name', models.CharField(max_length=30, null=True, verbose_name='\u0418\u043c\u044f', blank=True)),
                ('last_name', models.CharField(max_length=30, null=True, verbose_name='\u0424\u0430\u043c\u0438\u043b\u0438\u044f', blank=True)),
                ('middle_name', models.CharField(max_length=30, null=True, verbose_name='\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e', blank=True)),
                ('gender', models.IntegerField(default=3, blank=True, verbose_name='\u041f\u043e\u043b', choices=[(1, '\u041c\u0443\u0436\u0441\u043a\u043e\u0439'), (2, '\u0416\u0435\u043d\u0441\u043a\u0438\u0439'), (3, '\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e')])),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(auto_now_add=True, verbose_name='date joined')),
                ('parent_code', models.CharField(db_index=True, unique=True, max_length=15, verbose_name='\u041a\u043e\u0434 \u0434\u043b\u044f \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044f', blank=True)),
                ('is_teacher', models.BooleanField(default=False, verbose_name='\u0423\u0447\u0438\u0442\u0435\u043b\u044c')),
                ('is_parent', models.BooleanField(default=False, verbose_name='\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c')),
                ('is_content_manager', models.BooleanField(default=False, verbose_name='\u041a\u043e\u043d\u0442\u0435\u043d\u0442-\u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440')),
                ('phone_number', models.CharField(max_length=31, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430', blank=True)),
                ('avatar', models.ImageField(upload_to=kelvin.accounts.models.user.get_avatar_upload_path, null=True, verbose_name='\u0410\u0432\u0430\u0442\u0430\u0440\u043a\u0430', blank=True)),
                ('unsubscribed', models.BooleanField(default=False, verbose_name='\u041e\u0442\u043f\u0438\u0441\u0430\u043d \u043e\u0442 \u0440\u0430\u0441\u0441\u044b\u043b\u043e\u043a')),
            ],
            options={
                'verbose_name': '\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c',
                'verbose_name_plural': '\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438',
            },
        ),
        migrations.CreateModel(
            name='ParentProfile',
            fields=[
                ('parent', models.OneToOneField(related_name='parent_profile', primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL, verbose_name='\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c')),
            ],
            options={
                'verbose_name': '\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044f',
                'verbose_name_plural': '\u041f\u0440\u043e\u0444\u0438\u043b\u0438 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u0435\u0439',
            },
        ),
        migrations.CreateModel(
            name='TeacherProfile',
            fields=[
                ('teacher', models.OneToOneField(related_name='teacher_profile', primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL, verbose_name='\u0423\u0447\u0438\u0442\u0435\u043b\u044c')),
                ('school', models.CharField(max_length=255, verbose_name='\u0428\u043a\u043e\u043b\u0430', blank=True)),
                ('region', models.CharField(max_length=255, verbose_name='\u0420\u0435\u0433\u0438\u043e\u043d', blank=True)),
                ('subject', models.ForeignKey(verbose_name='\u041f\u0440\u0435\u0434\u043c\u0435\u0442 \u0443\u0447\u0438\u0442\u0435\u043b\u044f', blank=True, to='subjects.Subject', null=True)),
            ],
            options={
                'verbose_name': '\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u0443\u0447\u0438\u0442\u0435\u043b\u044f',
                'verbose_name_plural': '\u041f\u0440\u043e\u0444\u0438\u043b\u0438 \u0443\u0447\u0438\u0442\u0435\u043b\u0435\u0439',
            },
        ),
        migrations.AddField(
            model_name='user',
            name='groups',
            field=models.ManyToManyField(related_query_name='user', related_name='user_set', to='auth.Group', blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', verbose_name='groups'),
        ),
        migrations.AddField(
            model_name='user',
            name='user_permissions',
            field=models.ManyToManyField(related_query_name='user', related_name='user_set', to='auth.Permission', blank=True, help_text='Specific permissions for this user.', verbose_name='user permissions'),
        ),
        migrations.AddField(
            model_name='parentprofile',
            name='children',
            field=models.ManyToManyField(related_name='parents', verbose_name='\u0414\u0435\u0442\u0438 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044f', to=settings.AUTH_USER_MODEL, blank=True),
        ),
        migrations.CreateModel(
            name='UnapprovedTeacherProfile',
            fields=[
            ],
            options={
                'verbose_name': '\u041d\u0435\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0443\u0447\u0438\u0442\u0435\u043b\u044f',
                'proxy': True,
                'verbose_name_plural': '\u041d\u0435\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u044b\u0435 \u043f\u0440\u043e\u0444\u0438\u043b\u0438 \u0443\u0447\u0438\u0442\u0435\u043b\u0435\u0439',
            },
            bases=('accounts.teacherprofile',),
        ),
    ]
