# Generated by Django 1.11.10 on 2019-04-25 11:20
import logging

from django.db import migrations, models
import django.db.models.deletion


logger = logging.getLogger(__name__)


def remove_duplicated_userprojects(apps, schema_editor):
    UserProject = apps.get_model('accounts', 'UserProject')
    for user_project in UserProject.objects.distinct('user', 'project').filter():
         logger.info(
            UserProject.objects.filter(
                user=user_project.user,
                project=user_project.project,
            ).exclude(id__in=(user_project.id, )).delete()
         )


class Migration(migrations.Migration):

    dependencies = [
        ('projects', '0008_auto_20181230_1207'),
        ('accounts', '0009_user_yauid'),
    ]

    operations = [
        migrations.RunPython(remove_duplicated_userprojects, migrations.RunPython.noop),
        migrations.AlterModelOptions(
            name='userproject',
            options={'verbose_name': '\u041f\u0440\u043e\u0435\u043a\u0442 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f', 'verbose_name_plural': '\u041f\u0440\u043e\u0435\u043a\u0442\u044b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439'},
        ),
        migrations.AlterField(
            model_name='userproject',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='projects.Project', verbose_name='\u041f\u0440\u043e\u0435\u043a\u0442'),
        ),
        migrations.AlterUniqueTogether(
            name='userproject',
            unique_together=set([('user', 'project')]),
        ),
    ]
