import logging
from django.db import migrations, models


logger = logging.getLogger(__name__)


def create_index(apps, schema_editor):
    User = apps.get_model('accounts', 'User')
    User.objects.raw("""CREATE IF NOT EXISTS accounts_user_gist_username_first_name_last_name_idx 
    ON accounts_user USING GIST ((username || first_name || last_name) gist_trgm_ops)""")


def drop_index(apps, schema_editor):
    User = apps.get_model('accounts', 'User')
    User.objects.raw("""DROP INDEX accounts_user_gist_username_first_name_last_name_idx""")


class Migration(migrations.Migration):

    dependencies = [
        ('accounts', '0017_user_is_curator'),
    ]

    operations = [
        migrations.RunPython(create_index, drop_index),
    ]
