import logging
from django.db import migrations, models


logger = logging.getLogger(__name__)


def create_constraint(apps, schema_editor):
    User = apps.get_model('accounts', 'User')
    User.objects.raw("""ALTER TABLE accounts_user ADD CONSTRAINT accounts_user_yauid_key UNIQUE (yauid);""")


def drop_constraint(apps, schema_editor):
    User = apps.get_model('accounts', 'User')
    User.objects.raw("""alter table accounts_user drop constraint accounts_user_yauid_key""")


class Migration(migrations.Migration):

    dependencies = [
        ('accounts', '0018_create_gist_index_for_username_firstname_lastname'),
    ]

    operations = [
        migrations.AlterField(
            model_name='user',
            name='yauid',
            field=models.BigIntegerField(blank=True, null=True,
                                         verbose_name='\u042f\u043d\u0434\u0435\u043a\u0441 UID \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f'),
        ),
        migrations.RunPython(drop_constraint, create_constraint),
    ]
