from builtins import object

from django.conf import settings
from django.db import models
from django.utils.translation import ugettext_lazy as _


class ParentProfile(models.Model):
    parent = models.OneToOneField(
        settings.AUTH_USER_MODEL,
        verbose_name=_('Родитель'),
        related_name='parent_profile',
        primary_key=True,
    )
    children = models.ManyToManyField(
        settings.AUTH_USER_MODEL,
        verbose_name=_('Дети родителя'),
        related_name='parents',
        blank=True,
    )

    class Meta(object):
        verbose_name = _('Профиль родителя')
        verbose_name_plural = _('Профили родителей')
