from builtins import object, str

from django.conf import settings
from django.db import models
from django.utils.encoding import python_2_unicode_compatible
from django.utils.translation import ugettext_lazy as _

from kelvin.subjects.models import Subject


@python_2_unicode_compatible
class TeacherProfile(models.Model):
    teacher = models.OneToOneField(
        settings.AUTH_USER_MODEL,
        verbose_name='Учитель',
        related_name='teacher_profile',
        primary_key=True,
    )
    subject = models.ForeignKey(
        Subject,
        verbose_name=_('Предмет учителя'),
        blank=True,
        null=True,
    )
    school = models.CharField(
        verbose_name=_('Школа'),
        max_length=255,
        blank=True,
    )
    region = models.CharField(
        verbose_name=_('Регион'),
        max_length=255,
        blank=True,
    )

    def __str__(self):
        return 'TeacherProfile <{}>'.format(str(self.teacher))

    @property
    def approved(self):
        """
        Профиль подтвержден
        """
        return self.teacher.is_teacher

    class Meta(object):
        verbose_name = _('Профиль учителя')
        verbose_name_plural = _('Профили учителей')
