from builtins import object

from django.contrib.auth import get_user_model

from rest_framework import serializers

from kelvin.common.serializer_mixins import SerializerForeignKeyMixin

from .teacher import TeacherProfileSerializer

User = get_user_model()


class BaseUserSerializer(SerializerForeignKeyMixin, serializers.ModelSerializer):
    teacher_profile = TeacherProfileSerializer()
    yauser = serializers.SerializerMethodField()

    fk_update_fields = (
        'teacher_profile',
    )

    def get_yauser(self, value):
        """
        Берем яндексового пользователя из контекста
        """
        return self.context.get('yauser', None)

    def to_representation(self, instance):
        """
        Скрывает код родителя для учителей, родителей, контент-менеджеров
        """
        data = super(BaseUserSerializer, self).to_representation(instance)
        if (
            instance.is_teacher or
            instance.is_parent or
            instance.is_content_manager
        ):
            data.pop('parent_code')
        return data

    class Meta(object):
        model = User
        read_only_fields = (
            'id',
            'username',
            'is_staff',
            'date_joined',
            'email',
            'is_tos_accepted',
            'is_content_manager',
            'is_parent',
            'is_teacher',
            'parent_code',
            'yauser',
        )
        fields = (
            'first_name',
            'last_name',
            'middle_name',
            'gender',
            'avatar',
            'phone_number',
            'display_name',
            'teacher_profile',
        ) + read_only_fields
