from builtins import object

from django.contrib.auth import get_user_model

from rest_framework import serializers

from .base import BaseUserSerializer

User = get_user_model()


class ChildSerializer(BaseUserSerializer):
    """
    Сериализатор для ребенка родителя
    """
    courses = serializers.SerializerMethodField()

    class Meta(object):
        model = User
        fields = (
            'id',
            'first_name',
            'last_name',
            'courses',
            'avatar',
            'username',
        )

    def get_courses(self, obj):
        """
        Получение сериализованных курсов ученика
        Курсы берутся из контекста сериализатора по ключу `courses`
        """
        obj_courses = self.context.get('courses', {}).get(obj.id, [])
        return [{'id': id_, 'name': name}
                for id_, name in obj_courses]
