from builtins import object

from django.contrib.auth import get_user_model

from rest_framework import serializers

User = get_user_model()


class ProblemTheoryOwnerSerializer(serializers.ModelSerializer):
    """
    Сериализатор владельца задачи или теории
    """
    class Meta(object):
        model = User
        fields = (
            'id',
            'is_teacher',
            'is_content_manager',
        )


class CourseOwnerSerializer(serializers.ModelSerializer):
    """
    Сериализатор владельца курса
    """
    class Meta(object):
        model = User
        fields = (
            'id',
            'first_name',
            'last_name',
            'username',
        )
