from builtins import object

from kelvin.accounts.models import User

from .user import SimpleUserSerializer


class StudentSerializer(SimpleUserSerializer):
    """
    Сериализатор для вывода информации об учениках
    Используется в частности на странице курса в лаборатории для отображения информации о студентах
    """

    class Meta(object):
        model = User
        fields = SimpleUserSerializer.Meta.fields + (
            'id',
            'middle_name',
            'parent_code',
            'is_dismissed'
        )
        read_only_fields = ('subscription_end',)
