import random
import string
from builtins import object, range

from django.conf import settings

from rest_framework import serializers
from rest_framework.serializers import ModelSerializer

from kelvin.accounts.models import StudyGroup
from kelvin.accounts.serializers.user import SimpleUserSerializer
from kelvin.accounts.utils import get_user_projects


class StudyGroupSerializer(ModelSerializer):
    """Серилизатор учебной группы."""

    students = SimpleUserSerializer(many=True, read_only=True)
    owner = serializers.PrimaryKeyRelatedField(
        required=False,
        read_only=True,
        default=serializers.CurrentUserDefault(),
    )
    slug = serializers.CharField(read_only=True, required=False)

    class Meta(object):
        model = StudyGroup
        fields = ('id', 'owner', 'slug', 'students', 'name', 'project')
        read_only_fields = ('slug',)

    def validate_project(self, value):
        if value not in get_user_projects(user=self.context['request'].user):
            raise serializers.ValidationError("Invalid Project")
        return value

    def update(self, instance, validated_data):
        validated_data['project'] = instance.project  # Не даём обновлять project
        validated_data['owner'] = instance.owner  # Не даём обновлять owner
        return super(StudyGroupSerializer, self).update(instance, validated_data)

    def create(self, validated_data):
        validated_data['slug'] = ''.join(
            random.choice(string.ascii_letters) for _ in range(settings.STUDY_GROUP_SLUG_LEN)
        )
        return super(StudyGroupSerializer, self).create(validated_data)
