from builtins import object

from django.contrib.auth import get_user_model

from rest_framework import serializers
from rest_framework.fields import empty
from rest_framework.utils import html

from ..models import TeacherProfile

User = get_user_model()


class TeacherProfileSerializer(serializers.ModelSerializer):
    class Meta(object):
        model = TeacherProfile
        fields = (
            'subject',
            'region',
            'school',
        )

    # TODO убрать после перехода на новую версию (в 3.3.3 это есть)
    def get_value(self, dictionary):
        """
        В случае с form-data не надо возвращать словарь для вложенного объекта,
        если полей нет в данных
        """
        if html.is_html_input(dictionary):
            return (
                html.parse_html_dict(dictionary, prefix=self.field_name) or
                empty
            )
        return dictionary.get(self.field_name, empty)
