from django.db import models
from django.dispatch import receiver

from .models import User
from .services import (
    delete_parent_profile, delete_teacher_profile, get_or_create_parent_profile, get_or_create_teacher_profile,
)


def user_is_teacher_changed(instance):
    if instance.is_teacher:
        get_or_create_teacher_profile(instance)
    else:
        delete_teacher_profile(instance)


def user_is_parent_changed(instance):
    if instance.is_parent:
        get_or_create_parent_profile(instance)
    else:
        delete_parent_profile(instance)


@receiver(signal=models.signals.post_save, sender=User)
def user_post_save_handler(instance, **kwargs):
    if instance.tracker.has_changed('is_teacher'):
        user_is_teacher_changed(instance)

    if instance.tracker.has_changed('is_parent'):
        user_is_parent_changed(instance)
