from django_yauth.util import get_current_url, get_passport_url, get_yauth_type

from django.conf import settings
from django.template.defaultfilters import register


@register.simple_tag(takes_context=True)
def passport_create_url(context):
    request = context['request']
    retpath = get_current_url(request, add_params={settings.YAUTH_ANTI_REPEAT_PARAM: 1})
    return get_passport_url('create', get_yauth_type(request), request=request, retpath=retpath)
