from django.conf import settings
from django.template.defaultfilters import register


@register.simple_tag()
def password_reset_confirm_url(uid, token):
    """
    Адрес фронтенда с подтверждением восстановления пароля

    :param uid: закодированный уид пользователя
    :param token: токен для восстановления пароля
    """
    return settings.EMAIL_PASSWORD_RESET_URL.format(uid=uid, token=token)
