# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-08-05 11:17
from __future__ import unicode_literals

from django.conf import settings
import django.contrib.auth.validators
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import kelvin.common.validators
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('achievery', '0002_userachievement_request_if_exists'),
    ]

    operations = [
        migrations.CreateModel(
            name='AchievementTeam',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=255, verbose_name='Название')),
                ('captain_login', models.CharField(max_length=255, validators=[django.contrib.auth.validators.UnicodeUsernameValidator], verbose_name='Логин капитана')),
                ('participants_logins', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=list, validators=[kelvin.common.validators.list_of_logins_validator], verbose_name='логины участников')),
                ('status', models.CharField(choices=[('pending', 'в обработке'), ('ready', 'готова'), ('error', 'ошибка')], default='pending', max_length=16, verbose_name='статус')),
                ('error_messages', models.TextField(blank=True, verbose_name='сообщение об ошибке')),
                ('clesson_id', models.PositiveIntegerField(verbose_name='ID модуля')),
                ('captain', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='captain_in_achievement_teams', to=settings.AUTH_USER_MODEL, verbose_name='Капитан')),
                ('participants', models.ManyToManyField(blank=True, related_name='participant_in_achievement_teams', to=settings.AUTH_USER_MODEL, verbose_name='Участники')),
            ],
            options={
                'verbose_name': 'команда для ачивок',
                'verbose_name_plural': 'команды для ачивок',
            },
        ),
    ]
