# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-08-23 12:48
from __future__ import unicode_literals

from django.db import migrations, models
import django.core.validators


def migrate_achievery_level(apps, schema_editor):
    UserAchievement = apps.get_model('achievery', 'UserAchievement')
    UserAchievement.objects.filter(level=-1).update(level=0)


def migrate_achievery_level_reverse(apps, schema_editor):
    UserAchievement = apps.get_model('achievery', 'UserAchievement')
    UserAchievement.objects.filter(level=0).update(level=-1)


class Migration(migrations.Migration):

    dependencies = [
        ('achievery', '0003_achievementteam'),
    ]

    operations = [
        migrations.AlterField(
            model_name='userachievement',
            name='level',
            field=models.CharField(max_length=10, verbose_name='уровень', validators=[django.core.validators.RegexValidator('^[+-]?\\d+$')], help_text="n - точный уровень (0 - без уровня), +/-n - изменение уровня на n"),
        ),
        migrations.RunPython(migrate_achievery_level, migrate_achievery_level_reverse),
    ]
