# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-10-22 10:44
from __future__ import unicode_literals

from django.db import migrations
from django_celery_beat.models import (
    HOURS
)

grant_achievement_periodic_task_name = 'Grant achievement'
grant_achievement_periodic_task_path = 'kelvin.achievery.tasks.grant_achievement_periodic_task'


def forward(apps, schema_editor):
    IntervalSchedule = apps.get_model('django_celery_beat', 'IntervalSchedule')
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    interval, _ = IntervalSchedule.objects.get_or_create(
        period=HOURS,
        every=1,
    )

    task1, _ = PeriodicTask.objects.get_or_create(
        name=grant_achievement_periodic_task_name,
        defaults={
            'task': grant_achievement_periodic_task_path,
            'interval': interval,
        },
    )


def backward(apps, schema_editor):
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    PeriodicTask.objects.filter(
        name=grant_achievement_periodic_task_name,
    ).delete()


class Migration(migrations.Migration):
    dependencies = [
        ('django_celery_beat', '0006_auto_20180210_1226'),
        ('achievery', '0004_achievery_level'),
    ]

    operations = [
        migrations.RunPython(forward, backward),
    ]
