from rest_framework import serializers
from rest_framework.serializers import ModelSerializer

from kelvin.common.yandex_forms.fields import StaffLoginField, StaffLoginListField
from kelvin.common.yandex_forms.serializers import YandexFormModelSerializerMixin

from .models import AchievementTeam, achievement_level_validator


class ValidateAchievementInputSerializer(serializers.Serializer):
    achievement_id = serializers.IntegerField(required=True, min_value=1)
    level = serializers.CharField(required=True, max_length=10, validators=[achievement_level_validator])


class ValidateAchievementOutputSerializer(serializers.Serializer):
    id = serializers.IntegerField(required=True, min_value=1)


class TeamAchievementYandexFormCreateSerializer(YandexFormModelSerializerMixin, ModelSerializer):
    captain_login = StaffLoginField()
    participants_logins = StaffLoginListField()

    class Meta:
        model = AchievementTeam
        fields = (
            'name',
            'captain_login',
            'participants_logins',
            'clesson_id',
        )
