import logging

from django.utils import timezone

from ..achievery_client import client as achievery_client
from ..models import UserAchievement

logger = logging.getLogger(__name__)


def grant_achievement(user_achievement, force=False):
    if user_achievement.published_at is not None and not force:
        return

    resp = achievery_client.change_achievement(
        achievement_id=user_achievement.achievement_id,
        login=user_achievement.user.username,
        level=user_achievement.level,
        comment=user_achievement.comment,
        is_active=user_achievement.is_active,
        request_if_exists=user_achievement.request_if_exists,
    )

    UserAchievement.objects.filter(id=user_achievement.id).update(
        published_at=timezone.now(),
    )

    return resp
