from django.db import models, transaction
from django.dispatch import receiver

from .models import AchievementTeam, UserAchievement
from .tasks import grant_achievement_task, update_achievement_team_users_task


def grant_achievement(user_achievement):
    if user_achievement.published_at is None:
        transaction.on_commit(lambda: grant_achievement_task.delay(user_achievement_id=user_achievement.id))


@receiver(signal=models.signals.post_save, sender=UserAchievement)
def user_achievement_post_save_handler(sender, instance, **kwargs):
    grant_achievement(user_achievement=instance)


@receiver(signal=models.signals.post_save, sender=AchievementTeam)
def achievement_team_post_save_handler(sender, instance, **kwargs):
    transaction.on_commit(lambda: update_achievement_team_users_task.delay(achievement_team_id=instance.id))
