from builtins import object

from rest_framework import serializers

from kelvin.certificates.models import RenderedCertificate
from kelvin.common.serializer_fields import JSONDictField


class RenderedCertificateSerializer(serializers.ModelSerializer):
    """Сериализатор готовых сертификатов"""
    name = serializers.CharField(source='context.name')
    additional_context = JSONDictField(source='context.additional_context')

    class Meta(object):
        model = RenderedCertificate
        fields = ('file', 'name', 'additional_context')
        read_only_fields = ('file', 'name', 'additional_context')
