from builtins import range


def kuhn(graph, count_vertex_in1, count_vertex_in2):
    """
    Алгоритм Куна нахождения максимального паросочетания в двудольном
    графе. Входной граф ожидается в виде списка смежности. Размер
    изначального массива должен равняться `count_vertex_in1`.

    Возвращает кортеж из размера максимального паросочетания и
    самого паросочетания в формате массива размера `count_vertex_in2`
    где каждому элементу присвоена либо -1, если к нему не идет ребро,
    либо индекс вершины из первой доли
    """

    # Флаги использованности для вершин первой доли
    used = [False] * count_vertex_in1

    # Для каждой вершины из второй доли: в какую вершину
    # первой доли ведет паросочетание
    mt = [-1] * count_vertex_in2

    def kuhn_step(vertex):
        if used[vertex]:
            return False
        used[vertex] = True
        for adjacent_vertex in graph[vertex]:
            if mt[adjacent_vertex] == -1 or kuhn_step(mt[adjacent_vertex]):
                mt[adjacent_vertex] = vertex
                return True
        return False

    for current_vertex in range(count_vertex_in1):
        used = [False] * count_vertex_in1
        kuhn_step(current_vertex)

    max_matching_size = 0
    for el in mt:
        max_matching_size += el != -1
    return max_matching_size, mt
