from django.conf import settings
from django.db import DEFAULT_DB_ALIAS, connections
from django.test.utils import CaptureQueriesContext as _CaptureQueriesContext


class CaptureQueriesContext:

    def __init__(self):
        self.captures = {}
        for connection_name in settings.DATABASES:
            connection = connections[connection_name]
            capture = _CaptureQueriesContext(connection)
            self.captures[connection_name] = capture

    def __enter__(self):
        for capture_item in self.captures.values():
            capture_item.__enter__()
        return self

    def __exit__(self, exc_type, exc_value, traceback):
        for capture_item in self.captures.values():
            capture_item.__exit__(exc_type, exc_value, traceback)

    def __str__(self):
        return (
            'CaptureQueriesContext stats:\n'
            'Count: {count}\n'
            'Queries:\n'
            '{queries}'.format(
                count=len(self),
                queries='\n'.join(
                    query['sql'] for query in self.captured_queries
                )
            )
        )
