from django.db import IntegrityError


def safe_get_or_create(queryset, retry=True, **kwargs):
    """
    Handles the absence of atomicity of get_or_create
    :param queryset:
    :param retry: bool Return the object from DB in case get_or_create failed
    :return: tuple First item is a created object (or None if get_or_create
                   failed and retry=False), second is a bool flag indicating
                   if object is created
    """
    if not hasattr(queryset, 'get_or_create'):
        queryset = queryset.objects

    try:
        return queryset.get_or_create(**kwargs)
    except IntegrityError:
        # get_or_create is NOT atomic, unique constraint may be violated
        # https://stackoverflow.com/a/9400486/4878284
        if retry:
            kwargs.pop('defaults', None)
            return queryset.get(**kwargs), False
        else:
            return None, False
