def call_on_change(fields):
    """
    Decorator for save signal's handlers.
    Decorated function is called ONLY when some `fields` are changed.
    Fields are considered as changed if they are present in `update_fields=`
    kwarg for signal handlers.
    For details, see
    https://docs.djangoproject.com/en/1.11/ref/signals/#pre-save
    :param fields:      trigger fields (iterable)
    :return:            decorated function
    """

    def decorator(func):

        def wrapper(*args, **kwargs):
            # condition is necessary as `update_field` can be None
            changed_fields = kwargs.get('update_fields')

            if (
                not changed_fields or
                set(fields).intersection(changed_fields) or
                kwargs.get('created')
            ):
                return func(*args, **kwargs)
        return wrapper

    return decorator
