from time import time

from celery.utils.log import get_task_logger

logger = get_task_logger(__name__)


def logged_task(cls):
    """
    Decorator to log task start and finish with arguments
    :param cls:     celery task class to edit
    :return:        celery task class with logging around .run method
    """

    old_run = cls.run

    template_start = (
        "[celery_task_started] {task_name} {task_id} with "
        "args={args}, kwargs={kwargs}"
    )
    template_finish = (
        "[celery_task_finished] ({time_delta:.2f} sec) "
        "{task_name} {task_id} with args={args}, kwargs={kwargs}"
    )

    def new_run(*args, **kwargs):

        logger.info(template_start.format(
            task_name=cls.name,
            task_id=cls.request.id,
            args=args,
            kwargs=kwargs,
        ))

        time_started = time()

        old_run(*args, **kwargs)

        time_delta = time() - time_started

        logger.info(template_finish.format(
            task_name=cls.name,
            task_id=cls.request.id,
            args=args,
            kwargs=kwargs,
            time_delta=time_delta,
        ))

    cls.run = new_run

    return cls
