from django.utils.translation import ugettext_lazy as _

from rest_framework import status
from rest_framework.exceptions import APIException


class APIExceptionWithStatusCode(APIException):
    def __init__(self, detail=None, code=None, status_code=status.HTTP_500_INTERNAL_SERVER_ERROR):
        self.status_code = status_code
        super(APIExceptionWithStatusCode, self).__init__(detail=detail, code=code)


class ConflictError(APIException):
    status_code = status.HTTP_409_CONFLICT
    default_detail = _('Conflict request')
    default_code = 'conflict_request'
