from django.conf import settings
from django.contrib.postgres.fields import JSONField as PgJSONField

from kelvin.common.form_fields import JSONFormField
from kelvin.common.serializers import CustomDjangoJSONEncoder


class JSONField(PgJSONField):
    """
    Модель для JSON, с отображением русских символов и с отсупами
    """
    empty_values = list(settings.JSON_EMPTY_VALUES)

    def __init__(self, *args, **kwargs):
        # Устанавливаем по умолчанию encoder, который сериализует datetime
        if 'encoder' not in kwargs:
            kwargs['encoder'] = CustomDjangoJSONEncoder
        super(JSONField, self).__init__(*args, **kwargs)

    def formfield(self, **kwargs):
        """
        Переопределяем form_class на кастомный
        """
        defaults = {'form_class': JSONFormField}
        defaults.update(kwargs)

        return super(JSONField, self).formfield(**defaults)
