from django_filters.filters import Filter, Lookup

from kelvin.common.utils import dt_from_microseconds


def precise_datetime_filter(queryset, name, value):
    """
    Фильтрация поля `date_updated`
    """
    try:
        return queryset.filter(**{name: dt_from_microseconds(value)})
    except (ValueError, TypeError):
        return queryset


class ListFilter(Filter):
    """
    Списочный фильтр. Позволяет использовать параметры вида
    `field=value1,value2` для фильтрации по нескольким значениям поля
    """

    def filter(self, qs, value):
        """
        Разделяет аргументы в 'value', делает поиск
        """
        try:
            value_list = value.split(u',')
            return super(ListFilter, self).filter(qs, Lookup(value_list, 'in'))
        except (ValueError, TypeError):
            # При ошибке в параметре ничего не фильтруем
            return qs
