import json

from django.conf import settings
from django.contrib.postgres.forms import JSONField
from django.contrib.postgres.forms.jsonb import InvalidJSONInput


class JSONFormField(JSONField):
    """
    Поле для JSON с человекочитаемой репрезентацией
    """
    empty_values = list(settings.JSON_EMPTY_VALUES)

    def __init__(self, *args, **kwargs):
        super(JSONFormField, self).__init__(*args, **kwargs)

        self.inline = False

    def prepare_value(self, value):
        if isinstance(value, InvalidJSONInput):
            return value

        indent = None if self.inline else 2

        return json.dumps(value, indent=indent, ensure_ascii=False)
