from rest_framework.pagination import PageNumberPagination


class PaginationDefault(PageNumberPagination):
    def get_next_link(self):
        """
        Вместо ссылки отдаем номер следующей страницы
        """
        if not self.page.has_next():
            return None
        return self.page.next_page_number()

    def get_previous_link(self):
        """
        Вместо ссылки отдаем номер предыдущей страницы
        """
        if not self.page.has_previous():
            return None
        return self.page.previous_page_number()


class PaginationWithPageSize(PaginationDefault):
    """
    Paginator that writes page numbers instead of page links
    """
    page_size_query_param = 'page_size'
