from rest_framework.permissions import BasePermission


class IsDetailRequest(BasePermission):
    """
    Только получение одного объекта
    """

    def has_permission(self, request, view):
        return view.action == 'retrieve'


class IsListRequest(BasePermission):
    """
    Только получение списка объектов
    """

    def has_permission(self, request, view):
        return view.action == 'list'


class ObjectDetailRequest(BasePermission):
    """
    Только получение одного объекта
    """

    def has_object_permission(self, request, view, obj):
        return view.action == 'retrieve'


def tvm_service_permission_factory(allowed_tvm_ids):
    """
    Запрос пришел от одного из allowed_tvm_ids сервисов
    """
    class IsTVMServicePermission(BasePermission):
        def has_permission(self, request, view):
            return getattr(request, 'tvm_service_id', '') in allowed_tvm_ids

        def has_object_permission(self, request, view, obj):
            return getattr(request, 'tvm_service_id', '') in allowed_tvm_ids

    return IsTVMServicePermission
