import hashlib
from builtins import str

from kelvin.common.redis import redis


def get_key(func, args):
    key_string = str(func.__name__) + '_' + str(args)
    return hashlib.md5(key_string).hexdigest()  # noqa


def redis_cache(expire=None):
    """
    Redis cache method decorator.
    Checks value in cache
    If not in cache, saves func result to cache with expiration of `ex` param

    :param expire: cache expiration in seconds
    :return: func result
    """
    def decorator(func):
        def wrapped(*args, **kwargs):
            key = get_key(func, args)
            result = redis.client.get(key)
            if result is None:
                result = func(*args, **kwargs)
                redis.client.set(key, result, ex=expire)
            return result
        return wrapped
    return decorator
