from django_redis_sentinel.cache import RedisSentinelCache

from django.conf import settings


class RedisSentinelCacheWithStats(RedisSentinelCache):
    """
    Класс, позволяющий собирать hit/miss-статистику при обращении к кешу
    """
    HIT_KEY = 'hit-value'
    MISS_KEY = 'miss-value'
    __SPECIAL_KEYS_SET = set([HIT_KEY, MISS_KEY])

    def __init__(self, *args, **kwargs):
        super(RedisSentinelCacheWithStats, self).__init__(*args, **kwargs)

    def get(self, key, *args, **kwargs):
        value = super(RedisSentinelCacheWithStats, self).get(key, *args, **kwargs)
        if settings.ENABLE_CACHE_HIT_MISS_STATS and key not in self.__SPECIAL_KEYS_SET:
            if value:
                # такая пара вызовов гарантирует постоянное наличие и инкрементирование значения в кеше
                self.add(self.HIT_KEY, 0, timeout=None)
                self.incr(self.HIT_KEY, 1)

            else:
                self.add(self.MISS_KEY, 0, timeout=None)
                self.incr(self.MISS_KEY, 1)
        return value
