from django.core.cache import InvalidCacheBackendError, caches

from rest_framework.decorators import api_view
from rest_framework.response import Response

from .redis_cache import RedisSentinelCacheWithStats


@api_view(http_method_names=['GET'])
def hitmiss(request, **kwargs):
    """ это view отдаёт наружу значения hit/miss для переданного в параметре 'cache_name' кеша """
    cache_name = kwargs['cache_name']
    try:
        cache = caches[cache_name]
    except InvalidCacheBackendError:
        return Response("Cannot find a cache with such name: '{}'".format(cache_name))

    return Response(
        cache.get_many([
            RedisSentinelCacheWithStats.HIT_KEY,
            RedisSentinelCacheWithStats.MISS_KEY,
        ])
    )
