from startrek_client import Startrek

from django.utils.functional import SimpleLazyObject

from .settings import STARTREK_API_BASE_URL, STARTREK_API_OAUTH_TOKEN, STARTREK_USERAGENT


def get_client() -> Startrek:
    return Startrek(
        useragent=STARTREK_USERAGENT,
        base_url=STARTREK_API_BASE_URL,
        token=STARTREK_API_OAUTH_TOKEN,
    )


startrek_api = SimpleLazyObject(lambda: get_client())
