from tvm2 import TVM2
from tvm2.protocol import BlackboxClientId

from django.conf import settings
from django.utils.functional import SimpleLazyObject


def get_tvm2_client() -> TVM2:
    return TVM2(
        api_url=getattr(settings, 'TVM_API_URL', None),
        client_id=settings.TVM_CLIENT_ID,
        secret=settings.TVM_CLIENT_SECRET,
        blackbox_client=BlackboxClientId[settings.BLACKBOX_NAME],
        allowed_clients=settings.TVM_ALLOWED_CLIENTS,
    )


tvm2_client = SimpleLazyObject(lambda: get_tvm2_client())


def get_service_ticket(destination):
    return tvm2_client.get_service_tickets(str(destination)).get(destination)
