import re

from django.conf import settings
from django.conf.urls import url
from django.views.static import serve


def staticfiles_urlpatterns(prefix=None):
    """
    Отдаем статику даже при `DEBUG=False`
    """
    if prefix is None:
        prefix = settings.STATIC_URL
    return [
        url(r'^%s(?P<path>.*)$' % re.escape(prefix.lstrip('/')), serve,
            kwargs={'document_root': settings.STATIC_ROOT}),
    ]
