import re
from typing import List

from django.contrib.auth.validators import UnicodeUsernameValidator
from django.core.exceptions import ValidationError
from django.utils.translation import ugettext_lazy as _

COLOR_REGEX = re.compile(r'^#[0-9a-fA-F]{6}$')


def validate_color(color):
    """
    Проверяет, что строка цвета содержит 6 шестнадцатеричных цифр и
    `#` в начале.

    :param color: проверяемый цвет
    :type color: basestring

    :raises: django.core.exceptions.ValidationError
    """
    if not (COLOR_REGEX.match(color)):
        raise ValidationError(_(u"Incorrect color: {0}").format(color))


def list_of_logins_validator(logins: List[str]) -> List:
    if not isinstance(logins, list):
        raise ValidationError(_("не является списком"))


    invalid_logins = []
    login_validator = UnicodeUsernameValidator()
    for login in logins:
        try:
            if login is None:
                raise ValidationError(_("логин не должен быть пустым"))
            login_validator(login)
        except ValidationError:
            invalid_logins.append(login)

    if invalid_logins:
        raise ValidationError({'invalid_logins': invalid_logins})

    return logins
