import os

from django.contrib.admin.views.decorators import staff_member_required
from django.core.files.base import ContentFile
from django.core.files.storage import default_storage
from django.http import HttpResponse

from rest_framework.decorators import api_view, parser_classes, permission_classes
from rest_framework.parsers import MultiPartParser
from rest_framework.permissions import IsAuthenticated
from rest_framework.response import Response
from rest_framework.status import HTTP_400_BAD_REQUEST

from kelvin.common.utils import safe_filename


def ping(request):
    """
    Простая ручка ping для проверки работы джанги
    """
    message = 'pong'
    status = 200

    return HttpResponse(message, status=status, content_type='text/plain')


@staff_member_required
def simple_upload(request, name):
    """
    From http://diy-django.readthedocs.org/en/latest/ajaxupload.html
    """
    path = safe_filename(name, 'upload')
    path = default_storage.save(path, ContentFile(request.body))
    return HttpResponse(path, 'text/plain')


@api_view(http_method_names=['post'])
@parser_classes((MultiPartParser,))
@permission_classes((IsAuthenticated,))
def user_upload(request):
    """Загрузка пользовательских файлов"""
    if 'file' not in request.data:
        return Response({'file': 'field required'},
                        status=HTTP_400_BAD_REQUEST)
    file_ = request.data['file']
    user_dir = 'user/{0}'.format(request.user.username)
    path = safe_filename(file_.name, user_dir)
    # TODO storage exceptions
    path = default_storage.save(path, file_)
    return Response({'url': default_storage.url(path)})


# ручка с авторизацией для тестов
auth_ping = api_view(('GET',))(permission_classes((IsAuthenticated,))(ping))
