from rest_framework.fields import CharField

from .parsers import parse_staff_logins


class StaffLoginField(CharField):
    def to_internal_value(self, data):
        return next(iter(parse_staff_logins(data)), None)


class StaffLoginListField(CharField):
    def to_internal_value(self, data):
        return list(parse_staff_logins(data))
