from django_yauth.authentication_mechanisms.base import BaseMechanism
from django_yauth.user import AnonymousYandexUser, YandexTestUser

from django.contrib.auth import get_user_model

User = get_user_model()


class Mechanism(BaseMechanism):
    def extract_params(self, request):
        debug_uid = request.META.get('HTTP_DEBUG_UID')
        if not debug_uid:
            return

        return dict(
            yauid=debug_uid
        )

    def apply(self, yauid):
        try:
            user = User.objects.get(yauid=yauid)
        except User.DoesNotExist:
            return AnonymousYandexUser()

        defaults = {
            'login': user.username,
            'default_email': user.email,
            'need_reset': False,
            'is_lite': False,
            'is_social': False,
            'is_secure': False,
            'is_yandexoid': False,
            'new_session': None,
            'new_sslsession': None,
        }

        return YandexTestUser(**defaults)
