from django.conf import settings

# Рассказываем pytest где поискать наши фикстуры
pytest_plugins = [
    'integration_tests.fixtures.base',
    'integration_tests.fixtures.accounts',
    'integration_tests.fixtures.courses',
    'integration_tests.fixtures.lessons',
    'integration_tests.fixtures.problems',
    'integration_tests.fixtures.projects',
    'integration_tests.fixtures.results',
    'integration_tests.fixtures.settings',
    'integration_tests.fixtures.staff_notifications',
    'integration_tests.fixtures.subjects',
    'integration_tests.fixtures.tvm',
]

REPLICATION_MIDDLEWARE = 'django_replicated.middleware.ReplicationMiddleware'


def pytest_configure():
    """
    Заменяет асинхронное выполнение селери-тасков на синхронное,
    авторизующую мидлварь на тестовую, проставляем неавторизованного
    пользователя.
    Тестирует без репликации БД
    """
    settings.CELERY_ALWAYS_EAGER = True
    settings.MIDDLEWARE = tuple([x for x in settings.MIDDLEWARE if x != REPLICATION_MIDDLEWARE])
