from kelvin.common.admin import AvailableForSupportAdminMixin, AvailableForSupportInlineAdminMixin


class CourseAvailableForSupportAdminMixin(AvailableForSupportAdminMixin):
    def get_readonly_fields(self, request, obj=None):
        ro_fields = super().get_readonly_fields(request, obj)
        if obj is not None:
            user = request.user
            if user and not user.is_anonymous and user.is_authenticated and user.is_support:
                ro_fields = list(
                    set(ro_fields) |
                    {
                        'date_closed',
                        'code',
                        'author',
                        'owner',
                        'description',
                        'news',
                    } -
                    {'get_course_convert_link'}
                )

        return ro_fields

    def get_fields(self, request, obj=None):
        fields = super().get_fields(request, obj)
        if obj is not None:
            user = request.user
            if user and not user.is_anonymous and user.is_authenticated and user.is_support:
                fields = list(set(fields) - {'get_course_convert_link'})

        return fields


class CourseLessonLinkAvailableForSupportAdminMixinBase:
    def get_readonly_fields(self, request, obj=None, **kwargs):
        ro_fields = super().get_readonly_fields(request, obj)
        if obj is not None:
            user = request.user
            if user and not user.is_anonymous and user.is_authenticated and user.is_support:
                ro_fields = list(
                    set(ro_fields) |
                    {
                        'id',
                        'copy_of',
                        'mode',
                        'duration',
                        'max_attempts_in_group',
                        'show_answers_in_last_attempt',
                        'show_all_problems',
                        'accessible_to_teacher',
                        'lesson_editable',
                        'url',
                        'start_date',
                        'comment',
                        'date_assignment',
                        'date_completed',
                        'get_actions',
                        'finish_date',
                        'evaluation_date',
                        'diagnostics_text',
                        'visual_mode',
                    }
                )

        return ro_fields


class CourseLessonLinkAvailableForSupportAdminMixin(
    CourseLessonLinkAvailableForSupportAdminMixinBase,
    AvailableForSupportAdminMixin,
):
    pass


class CourseLessonLinkInlineAvailableForSupportAdminMixin(
    CourseLessonLinkAvailableForSupportAdminMixinBase,
    AvailableForSupportInlineAdminMixin,
):
    def get_readonly_fields(self, request, obj=None, **kwargs):
        ro_fields = super().get_readonly_fields(request, obj)
        if obj is not None:
            user = request.user
            if user and not user.is_anonymous and user.is_authenticated and user.is_support:
                ro_fields = list(
                    set(ro_fields) |
                    {
                        'get_clesson_front_link',
                        'get_lesson_name',
                        'get_lesson_link',
                    }
                )

        return ro_fields
